#include "../include/dvdsynth-device.h"

class IScannerCallbacks {
public:
   virtual bool UserAborted() = 0;
   virtual bool ReadSector(unsigned lba, unsigned char* buf) = 0;
   virtual void AddVOBU(unsigned vobu, unsigned lba, unsigned num_fields, unsigned num_data_blocks) = 0;
   virtual void ChangePTM(unsigned new_ptm) = 0;
   virtual void ChangeAngle(unsigned new_angle) = 0;
   virtual void Note(const char* msg) = 0;
   virtual void Warning(const char* msg) = 0;
   virtual void ErrorAtLBA(const char* msg, unsigned lba) = 0;
};

bool Scan(unsigned vobu_admap_lba, unsigned num_vobus, unsigned vts_vobs_lba, IScannerCallbacks* scanner_callbacks);
