#include "../include/dvdsynth-device.h"


struct TitlePGCInfo {
   unsigned subpicture_status_offset;  // add 0x88 for palette
   unsigned cell_playback_info_table_offset;
   unsigned cell_playback_info_table_end_offset;
};

struct TitleTmapInfo {
   unsigned offset;
   unsigned end_offset;
};

struct TitleSetInfo {
   unsigned vts_ifo_sector;
   unsigned vtsm_vobs_sector;
   unsigned vts_vobs_sector;
   unsigned vts_bup_sector;
   unsigned char number_of_existing_subpicture_tracks;
   bool ntsc;
   bool wide_aspect;
   unsigned vts_c_adt_offset;          // rel. to vts_ifo, only non multiples of 3
   unsigned vts_c_adt_end_offset;      // use byte count, not #cells!
   unsigned vts_vobu_admap_offset;     // rel. to vts_ifo
   unsigned vts_vobu_admap_end_offset;
   unsigned num_pgcs;
   TitlePGCInfo* pgcs;
   unsigned num_tmaps;
   TitleTmapInfo* tmaps;
};

struct DiscInfo {
   unsigned disc_id;
   unsigned vmg_ifo_sector;
   unsigned vmg_vobs_sector;
   unsigned vmg_bup_sector;
   unsigned vmg_tt_srpt_offset;
   unsigned vmg_tt_srpt_end_offset;
   unsigned num_title_sets;
   TitleSetInfo* titlesets;
};

struct SubpictureInfo {
   SubpictureInfo* next;
   unsigned hard_lba;  // rel. to start of disc
   unsigned file_offset;
   unsigned short data_len;
   unsigned char num_sectors;
   unsigned ptm;
};


enum State { stateActive=0, stateUpdating=1, stateUpdated=2 };


enum { first_data_packet_len = 2019, rest_data_packet_len = 2024 };


struct DVDSubberKernel : DvsDeviceKernel {
   DvsDeviceKernel* child;

   int state;

   dvs_file_handle data_file_handle;
   SubpictureInfo* subpic_inf;
   DiscInfo* disc_info;
   int num_subpics;
   unsigned palette[16];
   unsigned char palette_size;
   unsigned char title;

   unsigned char saved_scr[6];
   unsigned saved_scr_lba;

   unsigned Hard2Soft(unsigned sector);
   unsigned Soft2Hard(unsigned sector);
   void GenerateSubpictureSector(SubpictureInfo* si, unsigned subpic_rba, unsigned char* buffer);
   void PatchHardSector(unsigned hard_lba, unsigned char* buffer);
   void TranslateRelativeSector(unsigned char* pos, unsigned hard_sector, bool and_size);
   void UpdateSectorTable(unsigned offset, unsigned end_offset, unsigned record_min, unsigned record_size, unsigned base_lba, unsigned ifo_sector, unsigned char* buffer);
   void PatchVMGIFO(unsigned ifo_sector, unsigned char* buffer);
   void PatchVTSIFO(unsigned ts, const TitleSetInfo& tsi, unsigned ifo_sector, unsigned char* buffer);
   bool FindLBASource(unsigned soft_lba, unsigned num_blocks, unsigned* run_length, unsigned* hard_lba, SubpictureInfo** psi, unsigned* subpicture_rba);
   scsi_result_t ReadHardSectors(unsigned lba, unsigned count, unsigned char* buffer, SenseData* sense);
   scsi_result_t ReadSectors(unsigned soft_lba, unsigned num_soft_sectors, unsigned char* buffer, SenseData* sense);
};
