/***********************************************************************
 Copyright 2002 Ben Rudiak-Gould.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA,
 or visit <http://www.gnu.org/copyleft/gpl.html>.
***********************************************************************/


#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdlib.h>

#include "../include/dvdsynth-filter.h"
#include "DVDUnrestrict.h"


struct DvsDockingBayGlobal* g_callbacks;


struct DVDUnrestrictUser {
   struct DvsDeviceUser super;
   dvs_driver_handle kernel_driver;
};


void Delete(struct DvsDeviceUser* _self) {
   struct DVDUnrestrictUser* self = (void*) _self;
   g_callbacks->Driver_Unload(self->kernel_driver);
   free(self);
}


struct DvsDeviceUser_vtable vtable = {
   0, // AddDeviceMenuItems,
   0, // QueryUnplug
   Delete
};


struct DvsDeviceUser* HookDevice(struct DvsDeviceKernel** pkernel, struct DvsDockingBay* bay) {
   struct DVDUnrestrictUser* u;
   struct DVDUnrestrictKernel* k;

   u = malloc(sizeof(struct DVDUnrestrictUser));
   u->super.vtable = &vtable;
   u->kernel_driver = g_callbacks->Driver_Load("DVDUnrestrict.kll");

   k = bay->vtable->SharedPool_Alloc(bay, sizeof(struct DVDUnrestrictKernel));
   k->super.ScsiCommand = g_callbacks->Driver_Call(u->kernel_driver, "GetDispatchFunc", "");
   k->child = *pkernel;
   k->tt_srpt_sector = (unsigned)-1;
   k->pgci_sector   = (unsigned)-1;
   k->pgci_ut_sector = (unsigned)-1;

   *pkernel = &k->super;
   return &u->super;
}


struct DvsFilterGlobal plugin_info = {
	0,
	"Unrestrict DVD",
	DVDSYNTH_FILTER_ALL_DEVICE_CLASSES,
	HookDevice,
	0
};


struct DvsFilterGlobal* DvdsynthFilterPluginEntry(struct DvsDockingBayGlobal* callbacks) {
	g_callbacks = callbacks;
	return &plugin_info;
}
