#include "../include/dvdsynth-filter.h"


struct SavedCommandInfo {
   unsigned buffer_size : 26;
   unsigned inout : 2;
   unsigned cdb_size : 4;
   unsigned char cdb[12];
   scsi_result_t result;
   unsigned char buffer[12];
};


class LogCommandsFrameWindow;
class LogCommandsListView;

typedef void* HANDLE;


struct LogScsiKernel : DvsDeviceKernel {
   DvsDeviceKernel* child;
   unsigned event;
   bool log;
   bool ignore_testunitready;

   enum { queue_size = 64 };
   unsigned head,tail;
   SavedCommandInfo scis[queue_size];
};


struct LogScsiUser : DvsDeviceUser {
   const char* name;
   LogCommandsFrameWindow* frame;
   LogCommandsListView* listview;

   dvs_driver_handle driver_handle;
   LogScsiKernel* k;

   HANDLE hthread;
   HANDLE event;
   bool quit;

   enum { max_scis = 10000 };
   SavedCommandInfo scis[max_scis];
   int num_scis;
};
