/***********************************************************************
 Copyright 2002 Ben Rudiak-Gould.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA,
 or visit <http://www.gnu.org/copyleft/gpl.html>.
***********************************************************************/


#include "logscsi.h"


DvsDockingBayKernelGlobal* g_callbacks;


#define min(a,b) ((a)<(b)?(a):(b))


scsi_result_t __cdecl ScsiCommand(DvsDeviceKernel* _self, const unsigned char* cdb, int cdblen, unsigned char* buffer, unsigned long* pbuflen, int inout, SenseData* sense) {
   LogScsiKernel* self = (LogScsiKernel*)_self;
   SavedCommandInfo sci;
   bool ignore_command = !self->log || (cdb[0] == SCSIOP_TEST_UNIT_READY && self->ignore_testunitready);
   if (!ignore_command) {
      if (!(inout & 1)) {
         sci.buffer_size = *pbuflen;
         if (*pbuflen > 0) {
            g_callbacks->MemCpy(sci.buffer, buffer, min(12, *pbuflen));
         }
      } else {
         for (int i=0; i<*pbuflen && i<12; ++i) {
            buffer[i] = 0xEE;
         }
      }
      sci.inout = inout;
      sci.cdb_size = cdblen-1;
      g_callbacks->MemCpy(sci.cdb, cdb, min(12, cdblen));
   }
   sci.result = self->child->ScsiCommand(self->child, cdb, cdblen, buffer, pbuflen, inout, sense);
   if (!ignore_command) {
      if (inout & 1) {
         sci.buffer_size = *pbuflen;
         if (*pbuflen > 0)
            g_callbacks->MemCpy(sci.buffer, buffer, min(12, *pbuflen));
      }
      unsigned h = self->head, t = self->tail;
      if (h < t + self->queue_size) {
         self->scis[h % self->queue_size] = sci;
         self->head = h+1;
         g_callbacks->SetEvent(self->event);
      } else {
         g_callbacks->DebugPrintf("LOGSCSI: SCSI COMMAND WAS LOST\n");
      }
   }
   return sci.result;
}


extern "C"
void* __cdecl GetDispatchFunc() { return ScsiCommand; }

extern "C"
void __cdecl DvdsynthDriverInit(DvsDockingBayKernelGlobal* callbacks) {
   g_callbacks = callbacks;
}

extern "C"
unsigned __stdcall DLLEntry(void*, unsigned, void*) { return 1; }
