#ifndef __UI_H__
#define __UI_H__

class NestableWindow {
protected:
  HWND hwnd;
  static LONG APIENTRY StaticWndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
public:
  virtual LONG WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam) { return DefWindowProc(hwnd, message, wParam, lParam); }

  virtual LONG OnCreate(LPCREATESTRUCT lpcs) { return 0; }

  virtual bool OnMenuCommand(int id, bool is_accelerator) { return false; }
  virtual bool OnActivate(int activation_code, bool minimized, HWND other_window) { return false; }
  virtual bool OnSetFocus() { return false; }
  virtual bool OnSize(int width, int height) { return false; }
  virtual bool OnClose() { return true; }   // returns true to make close box have no effect
  virtual bool OnDestroy() { return false; }

  virtual bool OnControlCommand(int code) { return false; }
  virtual bool OnNotify(LPNMHDR pnmhdr);
  virtual bool OnDoubleClickOrEnterKey(LPNMHDR pnmhdr) { return false; }
  virtual void OnContextMenu(int x, int y) {}
  virtual bool OnMeasureItem(LPMEASUREITEMSTRUCT lpmis) { return false; }
  virtual bool OnDrawItem(LPDRAWITEMSTRUCT lpdis) { return false; }

  NestableWindow() : hwnd(0) {}
  virtual ~NestableWindow() {
    if (hwnd)
      DestroyWindow(hwnd);
  }

  void GetClientSize(int* width, int* height);
  HWND GetHwnd() { return hwnd; }
  void Show() { ShowWindow(hwnd, SW_SHOW); }
  void Hide() { ShowWindow(hwnd, SW_HIDE); }
};



class FrameWindow : public NestableWindow {
protected:
  NestableWindow* child;
  HWND hwndSavedFocus;

  virtual bool OnActivate(int activation_code, bool minimized, HWND other_window);
  virtual bool OnSize(int width, int height);
  void Resize();

public:
  FrameWindow(const char name[], HMENU hmenu = NULL);
  void SetChild(NestableWindow* new_child);
};



class SplitterWndH : public NestableWindow {
  NestableWindow *left, *right;

  void Create(NestableWindow* parent);

  virtual bool OnSize(int width, int height);
  void Resize();

  const int splitter_width;
  int splitter_pos;
  int resizing;

public:
  SplitterWndH(NestableWindow* parent);

  virtual LONG WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);

  void SetLeft(NestableWindow* new_left);
  void SetRight(NestableWindow* new_right);

  int GetClientWidthLeft() {
    return splitter_pos;
  }
  int GetClientWidthRight() {
    int width, height;
    GetClientSize(&width, &height);
    return width-splitter_width-splitter_pos;
  }
};



class ListView : public NestableWindow {
public:
  ListView(NestableWindow* parent);
  bool InsertColumn(int col, int width, const char caption[], int align);  // alignment: 0=left 1=right 2=center
  void SetNumItems(int n);
  void AddItem(bool autoscroll);
  void RedrawItems(int first, int last);
  void RedrawItem(int item) { RedrawItems(item, item); }
  virtual const char* GetItemText(int row, int col) = 0;
  virtual bool OnColumnClick(int col) { return false; }
  virtual bool OnNotify(LPNMHDR pnmhdr);
};



class ColorListBox : public NestableWindow {
  int old_horizontal_extent;
  virtual bool OnMeasureItem(LPMEASUREITEMSTRUCT lpmis);
  virtual bool OnDrawItem(LPDRAWITEMSTRUCT lpdis);
public:
  ColorListBox(NestableWindow* parent, bool multi_select);
  int InsertItem(const char text[], int index, COLORREF color);
  int AddItem(const char text[], COLORREF color, bool autoscroll=true);
  int GetCount() { return ListBox_GetCount(hwnd); }
};



class ColorLogWindow : public ColorListBox {
  const int max_entries;
public:
  ColorLogWindow(NestableWindow* parent, int _max_entries);
  void LogItem(const char text[], COLORREF color = 0);
};


#endif //__UI_H__
