#pragma pack(push,1)

typedef char CHAR;
typedef unsigned char BYTE;
typedef unsigned char UCHAR;
typedef unsigned short USHORT;
typedef unsigned long ULONG;
typedef void* PVOID;

#define DCB_dmd_phys_sgd      0x00000800
#define DCB_dmd_phys_sgd_ptr  0x00001000

struct DCB_COMMON {  // length = 80 decimal
    ULONG  DCB_physical_dcb;
    ULONG  DCB_expansion_length;
    PVOID  DCB_ptr_cd;
    ULONG  DCB_next_dcb;
    ULONG  DCB_next_logical_dcb;
    BYTE   DCB_drive_lttr_equiv;
    BYTE   DCB_unit_number;
    USHORT DCB_TSD_Flags;

    ULONG  DCB_vrp_ptr;
    ULONG  DCB_dmd_flags;
    ULONG  DCB_device_flags;
    ULONG  DCB_device_flags2;
    ULONG  DCB_Partition_Start;
    ULONG  DCB_track_table_ptr;
    ULONG  DCB_bds_ptr;
    ULONG  DCB_Reserved1;
    ULONG  DCB_Reserved2;
    BYTE   DCB_apparent_blk_shift;
    BYTE   DCB_partition_type;
    USHORT DCB_sig;
    BYTE   DCB_device_type;
    ULONG  DCB_Exclusive_VM;     /* danger! misaligned */
    BYTE   DCB_disk_bpb_flags;
    BYTE   DCB_cAssoc;
    BYTE   DCB_Sstor_Host;
    USHORT DCB_user_drvlet;
    USHORT DCB_Reserved3;
    ULONG  DCB_Reserved4;
};

#define DCB_DEV_PHYSICAL 0x00008000
#define DCB_DEV2_ATAPI_DEVICE 0x00000002

struct DCB_BLOCKDEV {
    ULONG  DCB_BDD_Next;
    BYTE   DCB_BDD_BD_Major_Version;
    BYTE   DCB_BDD_BD_Minor_Version;
    BYTE   DCB_BDD_Device_SubType;
    BYTE   DCB_BDD_Int_13h_Number;
    ULONG  DCB_BDD_flags;
    ULONG  DCB_BDD_Name_Ptr;

    ULONG  DCB_apparent_sector_cnt[2];
    ULONG  DCB_apparent_blk_size;
    ULONG  DCB_apparent_head_cnt;
    ULONG  DCB_apparent_cyl_cnt;
    ULONG  DCB_apparent_spt;

    ULONG  DCB_BDD_Sync_Cmd_Proc;
    ULONG  DCB_BDD_Command_Proc;
    ULONG  DCB_BDD_Hw_Int_Proc;
    ULONG  DCB_BDP_Cmd_Queue_Ascending;
    ULONG  DCB_BDP_Cmd_Queue_Descending;
    ULONG  DCB_BDP_Current_Flags;
    ULONG  DCB_BDP_Int13_Param_Ptr;
    ULONG  DCB_BDP_Current_Command;
    ULONG  DCB_BDP_Current_Position[2];
    ULONG  DCB_BDP_Reserved[5];
    ULONG  DCB_fastdisk_bdd;
};

#define DCB_BUS_ESDI 0
#define DCB_BUS_SCSI 1

struct DCB {
    DCB_COMMON  DCB_cmn;
    ULONG  DCB_max_xfer_len;           // 50

    ULONG  DCB_actual_sector_cnt[2];   // 54
    ULONG  DCB_actual_blk_size;        // 5C
    ULONG  DCB_actual_head_cnt;        // 60
    ULONG  DCB_actual_cyl_cnt;         // 64
    ULONG  DCB_actual_spt;             // 68

    PVOID  DCB_next_ddb_dcb;           // 6C
    PVOID  DCB_dev_node;               // 70
    BYTE   DCB_bus_type;               // 74
    BYTE   DCB_bus_number;             // 75
    BYTE   DCB_queue_freeze;           // 76
    BYTE   DCB_max_sg_elements;        // 77

    BYTE   DCB_io_pend_count;          // 78
    BYTE   DCB_lock_count;             // 79

    USHORT DCB_SCSI_VSD_FLAGS;         // 7A
    BYTE   DCB_scsi_target_id;         // 7C
    BYTE   DCB_scsi_lun;               // 7D
    BYTE   DCB_scsi_hba;               // 7E
    BYTE   DCB_max_sense_data_len;     // 7F
    USHORT DCB_srb_ext_size;           // 80

    BYTE   DCB_inquiry_flags[8];       // 82
    BYTE   DCB_vendor_id[8];
    BYTE   DCB_product_id[16];
    BYTE   DCB_rev_level[4];
    BYTE   DCB_port_name[8];
    BYTE   DCB_current_unit;

    ULONG  DCB_blocked_iop;

    ULONG  DCB_vol_unlock_timer;
    BYTE   DCB_access_timer;

    BYTE   DCB_Vol_Flags;

    BYTE  DCB_q_algo;
    BYTE  DCB_unit_on_ctl;
    ULONG  DCB_Port_Specific;
    ULONG  DCB_spindown_timer;

    DCB_BLOCKDEV  DCB_bdd;
};

typedef void (*CMDCPLT)();

struct IOR {
   ULONG   IOR_next;             // 00
   USHORT  IOR_func;             // 04
   USHORT  IOR_status;           // 06
   ULONG   IOR_flags;            // 08
   CMDCPLT IOR_callback;         // 0C
   ULONG   IOR_start_addr[2];    // 10
   ULONG   IOR_xfer_count;       // 18
   PVOID   IOR_buffer_ptr;       // 1C
   ULONG   IOR_private_client;   // 20
   ULONG   IOR_private_IOS;      // 24
   ULONG   IOR_private_port;     // 28
   ULONG   urequestor_usage[5];  // 2C
   PVOID   IOR_req_req_handle;   // 40
   ULONG   IOR_req_vol_handle;   // 44
   ULONG   IOR_sgd_lin_phys;     // 48
   BYTE    IOR_num_sgds;         // 4C
   BYTE    IOR_vol_designtr;     // 4D
   USHORT  IOR_ios_private_1;    // 4E
   ULONG   IOR_reserved_2[2];    // 50
};

#define IOR_SCSI_PASS_THROUGH  0x0F
#define IOR_SCSI_REQUEST       0x12
#define IORS_CMD_IN_PROGRESS   0x12
#define IORS_INVALID_COMMAND   0x16
#define IORS_NO_MEDIA          0x18
#define IORS_UNCERTAIN_MEDIA   0x19

#define IORF_HIGH_PRIORITY       0x00000001
#define IORF_SCATTER_GATHER      0x00000002  // BDCB physical SGD list present
#define IORF_DONT_CACHE          0x00000004  // don't cache BDCB data
#define IORF_BYPASS_VOLTRK       0x00000008  // request will not be volume tracked
#define IORF_16BIT_IOCTL         0x00000010
#define IORF_SWAPPER_IO          0x00000020  // request is from the swapper
#define IORF_DOUBLE_BUFFER       0x00000040
#define IORF_SYNC_CMD_DONE       0x00000080  // internal use only
#define IORF_SYNC_COMMAND        0x00000100
#define IORF_CHAR_COMMAND        0x00000200  // transfer counts and scatter/gather buffer sizes are byte values
#define IORF_VERSION_002         0x00000400  
#define IORF_BYPASS_QUEUE        0x00000800  // internal use only
#define IORF_BLOCKDEV_EMULATE    0x00001000
#define IORF_POSTPONED_VOL_OPS   0x00002000
#define IORF_INHIBIT_GEOM_RECOMPUTE 0x04000
#define IORF_SRB_VALID           0x00008000
#define IORF_BYPASS_A_B          0x00010000
#define IORF_QUIET_VOLTRK        0x00020000
#define IORF_AUDIO_DATA_READ     0x00040000
#define IORF_LOGICAL_START_SECTOR 0x0080000  // IOR_start_addr is logical
#define IORF_PARTITION_BIAS_ADDED 0x0100000  // set by TSD
#define IORF_DATA_IN             0x00200000  // data read
#define IORF_DATA_OUT            0x00400000  // data write
#define IORF_VOL_RETRY           0x00800000  // internal use only
#define	IORF_NO_COMPRESS         0x01000000
#define	IORF_DIRECT_IO           0x02000000  // e.g. INT 25h or INT 26h
#define IORF_PHYS_SGDS           0x04000000  // IOR_sgd_lin_phys valid
#define IORF_IO_TOO_BIG          0x08000000  // set by IOS criteria routine
#define IORF_WIN32               0x10000000  // I/O is from 32 bit API
#define IORF_CHAR_DEVICE         0x20000000
#define IORF_PHYS_CMD            0x40000000  // I/O is for a physical device
#define IORF_IDE_RESERVED        0x80000000


struct IOP_callback_entry {
   ULONG IOP_CB_address;
   ULONG IOP_CB_ref_data;
};

struct IOP {
   ULONG  IOP_physical;          // 00
   DCB*   IOP_physical_dcb;      // 04
   DCB*   IOP_original_dcb;      // 08
   USHORT IOP_timer;             // 0C
   USHORT IOP_timer_orig;        // 0E
   ULONG  IOP_calldown_ptr;      // 10
   ULONG  IOP_callback_ptr;      // 14
   ULONG  IOP_voltrk_private;    // 18
   ULONG  IOP_Thread_Handle;     // 1C
   ULONG  IOP_srb;               // 20
   ULONG  IOP_reserved[2];       // 24
   IOP_callback_entry IOP_callback_table[6];    // 2C
   BYTE   IOP_format_head;       // 5C
   BYTE   IOP_format_xfer_rate;  // 5D 
   USHORT IOP_format_track;      // 5E
   ULONG  IOP_format_num_sectors;// 60
   IOR    IOP_ior;               // 64
};

const unsigned offset_of_ior_in_iop = 100;


struct SGD {
   ULONG SG_buff_ptr;
   ULONG SG_buff_size;
};


struct DRP {
   CHAR   DRP_eyecatch_str[8];
   ULONG  DRP_LGN;
   PVOID  DRP_aer;
   PVOID  DRP_ilb;
   CHAR   DRP_ascii_name[16];
   BYTE   DRP_revision;
   ULONG  DRP_feature_code;      /* danger! misaligned */
   USHORT DRP_if_requirements;
   BYTE   DRP_bus_type;
   USHORT DRP_reg_result;
   ULONG  DRP_reference_data;
   BYTE   DRP_reserved1[2];
   ULONG  DRP_reserved2[1];
};

#define DRP_SCSI_LAYER 0x800


struct ISP {
   USHORT ISP_func;
   USHORT ISP_result;
};

#define ISP_CREATE_IOP         2
#define ISP_DEALLOC_MEM        4
#define ISP_GET_FIRST_NEXT_DCB 8

struct ISP_GET_FRST_NXT_DCB {
   ISP   ISP_gfnd_hdr;
   ULONG ISP_gfnd_dcb_offset;
   ULONG ISP_gfnd_found_dcb;
   BYTE  ISP_gfnd_dcb_type;
   BYTE  ISP_pad7[3];
};

// Why the hell is ISP_IOP_size 16 bits wide and ISP_delta_to_ior 32 bits
// wide when the former value is always larger? It even causes data
// misalignment for crying out loud!
struct ISP_IOP_create {
   ISP    ISP_i_c_hdr;
   USHORT ISP_IOP_size;
   ULONG  ISP_delta_to_ior;  /* danger! misaligned */
   ULONG  ISP_IOP_ptr;
   BYTE   ISP_i_c_flags;
   BYTE   ISP_pad2[1];
};

#define ISP_M_FL_INTERRUPT_TIME 1
#define ISP_M_FL_MUST_SUCCEED   2
#define ISP_M_FL_EXTERNAL_IOP   4

struct ISP_mem_dealloc {
   ISP   ISP_mem_da_hdr;
   ULONG ISP_mem_ptr_da;
};


typedef void (__cdecl *PFNISP)(ISP* pisp);
typedef unsigned (__cdecl *PFNIOR)(IOR* pior);
typedef unsigned (__cdecl *PFNIOP)(IOP* piop);

struct ILB {
   PFNISP ILB_service_rtn;
   PVOID  ILB_dprintf_rtn;
   PVOID  ILB_Wait_10th_Sec;
   PVOID  ILB_internal_request;
   PFNIOR ILB_io_criteria_rtn;
   PFNIOP ILB_int_io_criteria_rtn;
   ULONG  ILB_dvt;
   ULONG  ILB_ios_mem_virt;
   ULONG  ILB_enqueue_iop;
   ULONG  ILB_dequeue_iop;
   ULONG  ILB_reserved_1;
   ULONG  ILB_reserved_2;
   USHORT ILB_flags;
   CHAR   ILB_driver_numb;
   CHAR   ILB_reserved_3;
};


struct AEP {
   USHORT AEP_func;
   USHORT AEP_result;
   ULONG  AEP_ddb;
   UCHAR  AEP_lgn;
   UCHAR  AEP_align[3];
};

#define AEP_SUCCESS        0
#define AEP_FAILURE       -1


#pragma pack(pop)


typedef void* DEVNODE;
typedef ULONG CONFIGRET;

#define CR_SUCCESS 0


struct MirrorDriveKernel : DvsDeviceKernel {
   DCB* dcb;
};
