/***********************************************************************
 Copyright 2002 Ben Rudiak-Gould.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA,
 or visit <http://www.gnu.org/copyleft/gpl.html>.
***********************************************************************/


// dvdproxy.h - declarations related to the protocol between the
// user-mode and kernel-mode code


static unsigned char dvdproxy_device_inquiry_data[36] = {
   0x03,0x00,0x02,0x02,0x1F,0x00,0x00,0x02,
   'D','V','D','P','r','o','x','y',
   'd','u','m','m','y',' ','d','e','v','i','c','e',' ',' ',' ',' ',
   '1','.','0',' '
};


#define DVDPROXY_SIGNATURE "DVDSynth"

static const unsigned long DVDPROXY_CTLCODE_GET_SRB = 0xEEEEEEE0;
static const unsigned long DVDPROXY_CTLCODE_KEEP_ALIVE = 0xEEEEEEE1;
static const unsigned long DVDPROXY_CTLCODE_RETIRE_SRB = 0xEEEEEEE2;
static const unsigned long DVDPROXY_CTLCODE_BUS_CHANGE = 0xEEEEEEE3;
static const unsigned long DVDPROXY_CTLCODE_DETACH = 0xEEEEEEE4;

static const unsigned long DVDPROXY_RTNCODE_GOT_SRB = 0xEEEEEEF0;
static const unsigned long DVDPROXY_RTNCODE_NEED_MORE_DATA_SPACE = 0xEEEEEEF1;
static const unsigned long DVDPROXY_RTNCODE_LISTEN_TIMEOUT = 0xEEEEEEF2;
static const unsigned long DVDPROXY_RTNCODE_DETACH = 0xEEEEEEF3;
static const unsigned long DVDPROXY_RTNCODE_OLD_LISTENER = 0xEEEEEEF4;

struct RequestHeader {
   unsigned long sequence_number;
   unsigned char target;
   unsigned char data_transfer_direction;   // 1 = "in" (virtual device->app), 2 = "out" (app->virtual device)
   unsigned char cdb_length;
   unsigned char reserved;
};


struct SRB_IO_CONTROL {
   ULONG HeaderLength;
   UCHAR Signature[8];
   ULONG Timeout;
   ULONG ControlCode;
   ULONG ReturnCode;
   ULONG Length;
};


static const unsigned char DVDPROXY_SCSIOP = 0xEE;
static const unsigned char DVDPROXY_VERSION = 0x1F;

static const unsigned char DVDPROXY_CMD_GET_SRB = 100;
static const unsigned char DVDPROXY_CMD_KEEP_ALIVE = 101;
static const unsigned char DVDPROXY_CMD_RETIRE_SRB = 102;
static const unsigned char DVDPROXY_CMD_BUS_CHANGE = 103;
static const unsigned char DVDPROXY_CMD_SET_INQUIRY_DATA = 104;
static const unsigned char DVDPROXY_CMD_DETACH = 105;
static const unsigned char DVDPROXY_CMD_GENERATE_ERROR = 106;

// error messages
static const unsigned DVDPROXY_ERROR_INVALID_COMMAND = 0xEEEE0;
static const unsigned DVDPROXY_ERROR_WRONG_VERSION = 0xEEEEE;
static const unsigned DVDPROXY_ERROR_NEED_MORE_DATA_SPACE = 0xEEEE1;
static const unsigned DVDPROXY_ERROR_DETACH = 0xEEEE2;
static const unsigned DVDPROXY_ERROR_LISTEN_TIMEOUT = 0xEEEE3;
static const unsigned DVDPROXY_ERROR_OLD_LISTENER = 0xEEEE4;


struct CDB_Dvdproxy {
   unsigned char opcode;  // DVDPROXY_SCSIOP
   unsigned char version; // DVDPROXY_VERSION
   unsigned char cmd;
   unsigned char args[9];
};


// DVDPROXY_CMD_THUNK_CALL:
//    * Calls specified export from specified function in kernel mode.

struct CDB_Thunk_Call {
   unsigned char opcode;  // DVDPROXY_SCSIOP
   unsigned char version; // DVDPROXY_VERSION
   unsigned char cmd;     // DVDPROXY_CMD_THUNK_CALL
   unsigned char reserved;
   void*         hmodule;
   const char*   export_name;   // or ordinal
};

static const void* hmodule_miniport = (void*)~0;


struct CDB_GetSRB {
   unsigned char opcode;  // DVDPROXY_SCSIOP
   unsigned char version; // DVDPROXY_VERSION
   unsigned char cmd;     // DVDPROXY_CMD_GET_SRB
   unsigned char reserved1;
   unsigned short tick_length_in_ms;
   unsigned char listen_timeout;    // number of ticks before failing this SRB
   unsigned char response_timeout;  // number of ticks after this SRB returns before assuming user app is frozen
   unsigned char reserved2[4];
};

struct CDB_KeepAlive {
   unsigned char opcode;  // DVDPROXY_SCSIOP
   unsigned char version; // DVDPROXY_VERSION
   unsigned char cmd;     // DVDPROXY_CMD_KEEP_ALIVE
   unsigned char ticks;
   unsigned char reserved[8];
};

struct CDB_RetireSRB {
   unsigned char opcode;  // DVDPROXY_SCSIOP
   unsigned char version; // DVDPROXY_VERSION
   unsigned char cmd;     // DVDPROXY_CMD_RETIRE_SRB
   unsigned char sense_included;    // TRUE if SenseData structure included at end of buffer
   unsigned long sequence_number;
   unsigned char srb_status;
   unsigned char scsi_status;
   unsigned char reserved[2];
};

struct CDB_BusChange {
   unsigned char opcode;  // DVDPROXY_SCSIOP
   unsigned char version; // DVDPROXY_VERSION
   unsigned char cmd;     // DVDPROXY_CMD_BUS_CHANGE
   unsigned char reserved[9];
};

struct CDB_SetInquiryData {
   unsigned char opcode;  // DVDPROXY_SCSIOP
   unsigned char version; // DVDPROXY_VERSION
   unsigned char cmd;     // DVDPROXY_CMD_SET_INQUIRY_DATA
   unsigned char reserved[9];
};

struct CDB_GenerateError {
   unsigned char opcode;  // DVDPROXY_SCSIOP
   unsigned char version; // DVDPROXY_VERSION
   unsigned char cmd;     // DVDPROXY_CMD_GENERATE_ERROR
   unsigned char error_code;
   unsigned char reserved2[8];
};


struct UserModeRequest {   // 28 bytes
   unsigned long sequence_number;
   unsigned char target;
   unsigned char data_transfer_direction;   // 1 = "in" (virtual device->app), 2 = "out" (app->virtual device)
   unsigned char cdb_length;
   unsigned char reserved;
   unsigned long data_transfer_length;
   unsigned char cdb[16];
};


struct InquiryData {
   unsigned char inquiry_length;       // 0 means no device
   unsigned char modepage_2a_length;   // 0 means no such page
   unsigned char reserved[2];
   unsigned char inquiry[36];
   unsigned char modepage_2a[40];
};
