/***********************************************************************
 Copyright 2002 Ben Rudiak-Gould.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA,
 or visit <http://www.gnu.org/copyleft/gpl.html>.
***********************************************************************/


#include "ddk.h"


__declspec(naked)
void __cdecl DebugPrintf(const char* fmt, ...) {
   __asm {
      lea   eax,[esp+8]
      push  eax
      push  [esp+8]
      VXD_CALL(1,301)
      add   esp,8
      retn
   }
}


__declspec(naked)
int __stdcall Ring0_OpenCreate(unsigned flags, const char* pathname, unsigned* phandle) {
   __asm {
      push  ebx
      push  esi
      mov   eax,R0_OPENCREATFILE
      movzx ebx,word ptr [esp+12]
      xor   ecx,ecx
      movzx edx,word ptr [esp+14]
      mov   esi,[esp+16]
      VXD_CALL(64,50)  /* IFSMgr_Ring0_FileIO */
      jc    error

      mov   ecx,[esp+20]
      mov   [ecx],eax
      xor   eax,eax

error:
      /* could be a problem here if IFSMgr ever returns with carry set and AX==0! */
      cwde
      pop   esi
      pop   ebx
      retn  12
   }
}


__declspec(naked)
int __stdcall Ring0_ReadWrite(unsigned op, unsigned handle, unsigned pos, unsigned count, void* buf) {
   __asm {
      push  ebx
      push  esi
      mov   eax,[esp+12]
      mov   ebx,[esp+16]
      mov   edx,[esp+20]
      mov   ecx,[esp+24]
      mov   esi,[esp+28]
      VXD_CALL(64,50)  /* IFSMgr_Ring0_FileIO */
      pop   esi
      pop   ebx
      jc    failure
// MS docs say the # of bytes read/written is
// returned in ECX, but this is wrong! It's EAX.
// See http://groups.google.com/groups?selm=7cjk2f%24vas%2413%40reader1.reader.news.ozemail.net
//      mov   eax,ecx
      retn  20

failure:
      movzx eax,ax
      neg   eax
      retn  20
   }
}


__declspec(naked)
int __stdcall Ring0_SizeClose(unsigned op, unsigned handle) {
   __asm {
      push  ebx
      mov   eax,[esp+8]
      mov   ebx,[esp+12]
      VXD_CALL(64,50)  /* IFSMgr_Ring0_FileIO */
      pop   ebx
      jnc   success
      xor   eax,eax
success:
      retn  8
   }
}


__declspec(naked)
void __stdcall IOS_SendCommand(IOR* ior, DCB* dcb, DCB_BLOCKDEV* bdd) {
   __asm {
      pushad
      mov   esi,[esp+36]
      mov   edi,[esp+40]
      mov   ebx,[esp+44]
      VXD_CALL(16,4)
      popad
      retn  12
   }
}


__declspec(naked)
void __stdcall _VWIN32_CreateRing0Thread(void(__cdecl*thread_func)(void*), void* arg, void(__cdecl*failure_func)(void*)) {
   __asm {
      pushad
      mov   ecx,4096
      mov   edx,[esp+32+8]
      mov   ebx,[esp+32+4]
      mov   esi,[esp+32+12]
      VXD_CALL(42,19)
      popad
      retn  12
   }
}


__declspec(naked)
void __stdcall _VWIN32_CloseVxDHandle(unsigned handle) {
   __asm {
      pushad
      mov   eax,[esp+36]
      VXD_CALL(42,20)
      popad
      retn  4
   }
}


__declspec(naked)
unsigned __stdcall Create_Semaphore(unsigned token_count) {
   __asm {
      mov   ecx,[esp+4]
      VXD_CALL(1,37)
      jnc   noerror
      xor   eax,eax
noerror:
      retn  4
   }
}


__declspec(naked)
void __stdcall Wait_Semaphore(unsigned handle, unsigned flags) {
   __asm {
      mov   eax,[esp+4]
      mov   ecx,[esp+8]
      VXD_CALL(1,39)
      retn  8
   }
}


__declspec(naked)
void __stdcall Signal_Semaphore(unsigned handle) {
   __asm {
      mov   eax,[esp+4]
      VXD_CALL(1,40)
      retn  4
   }
}


__declspec(naked)
void __stdcall Signal_Semaphore_No_Switch(unsigned handle) {
   __asm {
      mov   eax,[esp+4]
      VXD_CALL(1,305)
      retn  4
   }
}


VXD_STACKCALL_SERVICE(  1,  85, ULONG   __cdecl   _PageFree(PVOID page, ULONG flags) );
VXD_STACKCALL_SERVICE(  1, 285, PVOID   __cdecl   _PageReserve(ULONG page, ULONG npages, ULONG flags) );
VXD_STACKCALL_SERVICE(  1, 286, ULONG   __cdecl   _PageCommit(ULONG page, ULONG npages, ULONG hpd, ULONG pagerdata, ULONG flags) );

VXD_STACKCALL_SERVICE( 16,   7, void    __cdecl   IOS_Register(DRP* drp) );

VXD_STACKCALL_SERVICE( 39,   7, int     __cdecl   _PELDR_LoadModule(HPEMODULE* phModule, char* filename, void* phlist) );
VXD_STACKCALL_SERVICE( 39,  11, void*   __cdecl   _PELDR_GetProcAddress(HPEMODULE hModule, const char* FuncName, void* phlist) );
VXD_STACKCALL_SERVICE( 39,  14, ULONG   __cdecl   _PELDR_FreeModule(HPEMODULE hModule, void* phlist) );

VXD_STACKCALL_SERVICE( 51,   2, CONFIGRET __cdecl CONFIGMG_Locate_DevNode(DEVNODE* pdn, void* device_id, ULONG flags) );
VXD_STACKCALL_SERVICE( 51,   3, CONFIGRET __cdecl CONFIGMG_Get_Parent(DEVNODE* pdn, DEVNODE dn, ULONG flags) );
VXD_STACKCALL_SERVICE( 51,   4, CONFIGRET __cdecl CONFIGMG_Get_Child(DEVNODE* pdn, DEVNODE dn, ULONG flags) );
VXD_STACKCALL_SERVICE( 51,   5, CONFIGRET __cdecl CONFIGMG_Get_Sibling(DEVNODE* pdn, DEVNODE dn, ULONG flags) );
VXD_STACKCALL_SERVICE( 51,  12, CONFIGRET __cdecl CONFIGMG_Query_Remove_SubTree(DEVNODE dnAncestor, ULONG flags) );
VXD_STACKCALL_SERVICE( 51,  13, CONFIGRET __cdecl CONFIGMG_Remove_SubTree(DEVNODE dnAncestor, ULONG flags) );
VXD_STACKCALL_SERVICE( 51,  51, CONFIGRET __cdecl CONFIGMG_Reenumerate_DevNode(DEVNODE dn, ULONG synchronous) );
