/***********************************************************************
 Copyright 2002 Ben Rudiak-Gould.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA,
 or visit <http://www.gnu.org/copyleft/gpl.html>.
***********************************************************************/


static unsigned char dvdproxy_device_inquiry_data[36] = {
   0x03,0x00,0x02,0x02,0x1F,0x00,0x00,0x02,
   'D','V','D','P','r','o','x','y',
   'd','u','m','m','y',' ','d','e','v','i','c','e',' ',' ',' ',' ',
   '1','.','0',' '
};


static const unsigned char DVDPROXY_SCSIOP = 0xEE;
static const unsigned char DVDPROXY_VERSION = 0x1F;

static const unsigned char DVDPROXY_CMD_THUNK_CALL = 200;
static const unsigned char DVDPROXY_CMD_HELLO = 201;

// error messages
static const unsigned DVDPROXY_ERROR_INVALID_COMMAND = 0xEEEE0;
static const unsigned DVDPROXY_ERROR_WRONG_VERSION = 0xEEEEE;
static const unsigned DVDPROXY_ERROR_THUNK_CALL_SUCCEEDED = 0xEEEE8;
static const unsigned DVDPROXY_ERROR_EXPORT_NOT_FOUND = 0xEEEE9;


struct CDB_Dvdproxy {
   unsigned char opcode;  // DVDPROXY_SCSIOP
   unsigned char version; // DVDPROXY_VERSION
   unsigned char cmd;
   unsigned char args[9];
};


// DVDPROXY_CMD_THUNK_CALL:
//    * Calls specified export from specified function in kernel mode.

struct CDB_Thunk_Call {
   unsigned char opcode;  // DVDPROXY_SCSIOP
   unsigned char version; // DVDPROXY_VERSION
   unsigned char cmd;     // DVDPROXY_CMD_THUNK_CALL
   unsigned char reserved;
   void*         hmodule;
   const char*   export_name;   // or ordinal
};

static const void* hmodule_miniport = (void*)~0;
