//#define WORKER_THREAD


struct DVDProxy {

#ifdef WORKER_THREAD

   unsigned semaphore_handle;

   bool WorkerThreadInitialized() { return semaphore_handle != 0; }
   void InitWorkerThread();

   enum { max_outstanding_srbs = 4 };
   bool srb_complete[max_outstanding_srbs];
   SCSI_REQUEST_BLOCK* srbs[max_outstanding_srbs];

#endif

   DvsDeviceKernel* handlers[32];

   void Complete(SCSI_REQUEST_BLOCK* completed_srb);

   void CompleteWithSrbStatus(SCSI_REQUEST_BLOCK* completed_srb, UCHAR srb_status) {
      completed_srb->SrbStatus = srb_status;
      completed_srb->ScsiStatus = SCSISTAT_GOOD;
      Complete(completed_srb);
   }

   BOOLEAN ResetBus(ULONG PathId);
   BOOLEAN StartIo(SCSI_REQUEST_BLOCK* Srb);
};


void MemSet(void* dst, int val, unsigned long count);


#ifdef WORKER_THREAD
void __cdecl WorkerThreadProc(void* _self);
#else
void __cdecl WorkProc(DVDProxy* self, SCSI_REQUEST_BLOCK* srb);
#endif

extern DvsDeviceKernel dummy_device;


#define min(a,b) ((a)<(b)?(a):(b))
#define max(a,b) ((a)<(b)?(b):(a))
