// SRB_Cmd values
#define SC_HA_INQUIRY               0x00
#define SC_GET_DEV_TYPE             0x01
#define SC_EXEC_SCSI_CMD            0x02
#define SC_ABORT_SRB                0x03
#define SC_RESET_DEV                0x04
#define SC_SET_HA_PARMS             0x05
#define SC_GET_DISK_INFO            0x06
#define SC_RESCAN_SCSI_BUS          0x07
#define SC_GETSET_TIMEOUTS          0x08

// SRB_Flags values
#define SRB_DIR_SCSI                0x00        // Direction determined by SCSI
#define SRB_POSTING                 0x01        // Enable ASPI posting
#define SRB_ENABLE_RESIDUAL_COUNT   0x04        // Enable residual byte count reporting
#define SRB_DIR_IN                  0x08        // Transfer from SCSI target to host
#define SRB_DIR_OUT                 0x10        // Transfer from host to SCSI target
#define SRB_EVENT_NOTIFY            0x40        // Enable ASPI event notification

// SRB_Status values
#define SS_PENDING                  0x00        // SRB being processed
#define SS_COMP                     0x01        // SRB completed without error
#define SS_ABORTED                  0x02        // SRB aborted
#define SS_ABORT_FAIL               0x03        // Unable to abort SRB
#define SS_ERR                      0x04        // SRB completed with error
#define SS_INVALID_CMD              0x80        // Invalid ASPI command
#define SS_INVALID_HA               0x81        // Invalid host adapter number
#define SS_NO_DEVICE                0x82        // SCSI device not installed
#define SS_INVALID_SRB              0xE0        // Invalid parameter set in SRB
#define SS_BUFFER_ALIGN             0xE1        // Buffer not aligned
#define SS_ILLEGAL_MODE             0xE2        // Attempted to start ASPI from Win32s
#define SS_NO_ASPI                  0xE3        // APIX.VXD or ASPI32.SYS not found
#define SS_FAILED_INIT              0xE4        // ASPI for windows failed init
#define SS_ASPI_IS_BUSY             0xE5        // No resources available to execute cmd
#define SS_BUFFER_TO_BIG            0xE6        // Buffer size too big (usually >64K)
#define SS_MISMATCHED_COMPONENTS    0xE7        // The DLLs/EXEs of ASPI don't version check
#define SS_NO_ADAPTERS              0xE8        // No host adapters to manage
#define SS_INSUFFICIENT_RESOURCES   0xE9        // Couldn't allocate resources needed to init
#define SS_ASPI_IS_SHUTDOWN         0xEA        // Call came to ASPI after PROCESS_DETACH
#define SS_BAD_INSTALL              0xEB        // The DLL or other components are installed wrong

#define SENSE_LEN                   14          // Default sense buffer length

struct SRB_HAInquiry {
    unsigned char /*in */ SRB_Cmd;         // SC_HA_INQUIRY
    unsigned char /*out*/ SRB_Status;
    unsigned char /*in */ SRB_HaId;
    unsigned char /* 0 */ SRB_Flags;
    unsigned int  /* 0 */ SRB_Hdr_Rsvd;
    unsigned char /*out*/ HA_Count;
    unsigned char /*out*/ HA_SCSI_ID;
    unsigned char /*out*/ HA_ManagerId[16];
    unsigned char /*out*/ HA_Identifier[16];
    unsigned char /*out*/ HA_Unique[16];
    unsigned short/* 0 */ HA_Rsvd1;
};

struct SRB_GDEVBlock {
    unsigned char /*in */ SRB_Cmd;         // SC_GET_DEV_TYPE
    unsigned char /*out*/ SRB_Status;
    unsigned char /*in */ SRB_HaId;
    unsigned char /* 0 */ SRB_Flags;
    unsigned int  /* 0 */ SRB_Hdr_Rsvd;
    unsigned char /*in */ SRB_Target;
    unsigned char /*in */ SRB_Lun;
    unsigned char /*out*/ SRB_DeviceType;
    unsigned char /* 0 */ SRB_Rsvd1;
};

struct SRB_ExecSCSICmd {
    unsigned char   /*in */ SRB_Cmd;       // SC_EXEC_SCSI_CMD
    unsigned char   /*out*/ SRB_Status;
    unsigned char   /*in */ SRB_HaId;
    unsigned char   /*in */ SRB_Flags;
    unsigned int    /* 0 */ SRB_Hdr_Rsvd;
    unsigned char   /*in */ SRB_Target;
    unsigned char   /*in */ SRB_Lun;
    unsigned short  /* 0 */ SRB_Rsvd1;
    unsigned int   /*inout*/SRB_BufLen;
    unsigned char * /*in */ SRB_BufPointer;
    unsigned char   /*in */ SRB_SenseLen;
    unsigned char   /*in */ SRB_CDBLen;
    unsigned char   /*out*/ SRB_HaStat;
    unsigned char   /*out*/ SRB_TargStat;
    void *          /*in */ SRB_PostProc;
    unsigned char   /* 0 */ SRB_Rsvd2[20];
    unsigned char   /*in */ CDBByte[16];
    unsigned char   /*out*/ SenseArea[SENSE_LEN+2];
};

struct SRB_Abort {
    unsigned char /*in */ SRB_Cmd;         // SC_ABORT_SRB
    unsigned char /*out*/ SRB_Status;
    unsigned char /*in */ SRB_HaId;
    unsigned char /* 0 */ SRB_Flags;
    unsigned int  /* 0 */ SRB_Hdr_Rsvd;
    void *        /*in */ SRB_ToAbort;
};

struct SRB_BusDeviceReset {
    unsigned char /*in */ SRB_Cmd;         // SC_RESET_DEV
    unsigned char /*out*/ SRB_Status;
    unsigned char /*in */ SRB_HaId;
    unsigned char /* 0 */ SRB_Flags;
    unsigned int  /* 0 */ SRB_Hdr_Rsvd;
    unsigned char /*in */ SRB_Target;
    unsigned char /*in */ SRB_Lun;
    unsigned char /* 0 */ SRB_Rsvd1[12];
    unsigned char /*out*/ SRB_HaStat;
    unsigned char /*out*/ SRB_TargStat;
    void *        /*in */ SRB_PostProc;
    unsigned char /* 0 */ SRB_Rsvd2[36];
};

// Struct for SC_SET_HA_PARMS unknown!

struct SRB_GetDiskInfo {
    unsigned char /*in */ SRB_Cmd;         // SC_GET_DISK_INFO
    unsigned char /*out*/ SRB_Status;
    unsigned char /*in */ SRB_HaId;
    unsigned char /* 0 */ SRB_Flags;
    unsigned int  /* 0 */ SRB_Hdr_Rsvd;
    unsigned char /*in */ SRB_Target;
    unsigned char /*in */ SRB_Lun;
    unsigned char /*out*/ SRB_DriveFlags;
    unsigned char /*out*/ SRB_Int13HDriveInfo;
    unsigned char /*out*/ SRB_Heads;
    unsigned char /*out*/ SRB_Sectors;
    unsigned char /* 0 */ SRB_Rsvd1[10];
};

struct SRB_RescanPort {
    unsigned char SRB_Cmd;                 // SC_RESCAN_SCSI_BUS
    unsigned char SRB_Status;
    unsigned char SRB_HaId;
    unsigned char SRB_Flags;
    unsigned int  SRB_Hdr_Rsvd;
};

struct SRB_GetSetTimeouts {
    unsigned char /*in */ SRB_Cmd;         // SC_GETSET_TIMEOUTS
    unsigned char /*out*/ SRB_Status;
    unsigned char /*in */ SRB_HaId;
    unsigned char /*in */ SRB_Flags;
    unsigned int  /* 0 */ SRB_Hdr_Rsvd;
    unsigned char /*in */ SRB_Target;
    unsigned char /*in */ SRB_Lun;
    unsigned int /*inout*/SRB_Timeout;
};

typedef void * LPSRB;
