/* This header file is in the public domain. */


#ifndef __DVDSYNTH_DEVICE_H
#define __DVDSYNTH_DEVICE_H


#include "dvdsynth-plugin.h"
#include "dvdsynth-scsi.h"


typedef void* dvs_driver_handle;

typedef void* dvs_file_handle;


struct DvsDeviceKernel;
struct DvsDeviceUser;


typedef scsi_result_t __cdecl dvs_scsi_func (struct DvsDeviceKernel* self, const unsigned char* cdb, int cdblen, unsigned char* buffer, unsigned long* pbuflen, int inout, SenseData* sense);


struct DvsDeviceUser {
   struct DvsDeviceUser_vtable *vtable;
};

struct DvsDeviceUser_vtable {
   void (__cdecl *AddDeviceMenuItems) (struct DvsDeviceUser* self, struct DvsMenu* menu);
   int  (__cdecl *QueryUnplug) (struct DvsDeviceUser* self);
   void (__cdecl *Delete) (struct DvsDeviceUser* self);
};


struct DvsDockingBay {
   struct DvsDockingBay_vtable* vtable;
};

struct DvsDockingBay_vtable {
   void     (__cdecl *SetHandlers) (struct DvsDockingBay* self, struct DvsDeviceUser* user_handler, struct DvsDeviceKernel* kernel_handler);
   void     (__cdecl *RequestUnplug) (struct DvsDockingBay* self);
   void*    (__cdecl *SharedPool_Alloc) (struct DvsDockingBay* self, unsigned len);
   int      (__cdecl *GetScsiID) (struct DvsDockingBay* self);
   unsigned (__cdecl *GetDriveLetters) (struct DvsDockingBay* self);
};


struct DvdVideoInfo {
   unsigned vmg_ifo_sector;
   unsigned vmg_ifo_icb_sector, vmg_ifo_icb_length;
   unsigned video_ts_sector, video_ts_length;
   unsigned video_ts_icb_sector, video_ts_icb_length;
   unsigned root_sector, root_length;
   unsigned root_icb_sector, root_icb_length;
   unsigned fsd_sector, fsd_length;
   unsigned partition_sector, partition_sectors;
   unsigned mvds_sector, mvds_length;
};


struct DvsDockingBayGlobal {
   struct DvsDockingBay* (__cdecl *ReserveDockingBay) (void);

   dvs_driver_handle (__cdecl *Driver_Load) (const char* pathname);
   void*             (__cdecl *Driver_Call) (dvs_driver_handle handle, const char* exported_name, const char* types, ...);
   void              (__cdecl *Driver_Unload) (dvs_driver_handle handle);

   int  (__cdecl *OpenFileRO) (dvs_file_handle* phandle, const char* pathname);
   int  (__cdecl *CreateOrOpenFileRW) (dvs_file_handle* phandle, const char* pathname, int creation_disposition);
   void (__cdecl *CloseFile) (dvs_file_handle handle);

   unsigned (__cdecl *OpenKernelEventHandle) (void* user_handle);
   void     (__cdecl *CloseKernelEventHandle) (unsigned kernel_handle);

   int   (__cdecl *Is95) (void);

   dvs_scsi_func* KernelScsiCommand;

   int (__cdecl *GetDvdVideoInfo) (struct DvsDeviceKernel* device, struct DvdVideoInfo* info);

   unsigned (__cdecl *GetDvdsynthDevicesID) (void);

   int   (__cdecl   *Sprint) (char* buf, int space, const char* fmt, const char* types, ...);
   const char* (__cdecl *GetDvdsynthDirectory) (void);
   void* (__cdecl *GetTaskbarHWND) (void);
};


struct DvsDeviceGlobal {
   void                  (__cdecl *AddNewMenuItems)   (struct DvsMenu* menu);
   void                  (__cdecl *AddAboutMenuItems) (struct DvsMenu* menu);
   void                  (__cdecl *AddMainMenuItems)  (struct DvsMenu* menu);
   struct DvsDockingBay* (__cdecl *HookDockingBay)    (struct DvsDockingBay* original_docking_bay);
};


/* struct DvsDeviceGlobal* __cdecl DvdsynthDevicePluginEntry(struct DvsDockingBayGlobal*); */


struct DvsDeviceKernel {
   dvs_scsi_func* ScsiCommand;
};


struct DvsDockingBayKernelGlobal {
   void (__cdecl *MemSet) (void* dst, int val, unsigned long count);
   void (__cdecl *MemCpy) (void* dst, const void* src, unsigned long count);
   void (__cdecl *DebugPrintf) (const char* fmt, ...);
   void (__cdecl *AsyncUserModeCall) (void (__cdecl*)(void*, int), void*, int);
   int  (__cdecl *ReadFile) (dvs_file_handle file_handle, unsigned offset, unsigned offset_high, unsigned count, void* buf);
   int  (__cdecl *WriteFile) (dvs_file_handle file_handle, unsigned offset, unsigned offset_high, unsigned count, void* buf);
   void (__cdecl *SetEvent) (unsigned event_handle);
//   void (__cdecl *CloseEventHandle) (unsigned event_handle);
//   scsi_result_t (__cdecl *SendScsiCommand) (int device, const unsigned char* cdb, int cdblen, unsigned char* buffer, unsigned long* pbuflen, int inout, SenseData* sense);
};


/* void __cdecl DvdsynthDriverInit(DvsDockingBayKernelGlobal* callbacks); */


#endif
