/* This header file is in the public domain. */


#ifndef __DVDSYNTH_PLUGIN_H
#define __DVDSYNTH_PLUGIN_H


struct DvsMenu {
   struct DvsMenu_vtable* vtable;
};

struct DvsMenu_vtable {
   void (__cdecl *AddSeparator) (struct DvsMenu* self);
   void (__cdecl *AddItem) (struct DvsMenu* self, const char* text, int checked, void (__cdecl *callback)(void* ,int), void* p, int i);
   void (__cdecl *AddDisabledItem) (struct DvsMenu* self, const char* text, int checked);
   void (__cdecl *BeginSubmenu) (struct DvsMenu* self, const char* text, int disabled);
   void (__cdecl *EndSubmenu) (struct DvsMenu* self);
};


struct DvsBasePluginFunctions {
   void (__cdecl *AddMainMenuItems) (struct DvsMenu* menu);
   void (__cdecl *AddOptionsMenuItems) (struct DvsMenu* menu);
   void (__cdecl *AddAboutMenuItems) (struct DvsMenu* menu);
   int  (__cdecl *QueryExit) (void);
   void (__cdecl *NotifyExit) (void);
};


struct DvsBasePluginCallbacks {
   int   (__cdecl *Sprint) (char* buf, int space, const char* fmt, const char* types, ...);
   const char* (__cdecl *GetDvdsynthDirectory) (void);
   void* (__cdecl *GetTaskbarHWND) (void);
};


struct DvsPersist {
   struct DvsPersist_vtable* vtable;
};

struct DvsPersist_vtable {
   void (__cdecl *PutInt)    (struct DvsPersist* self, const char* name, int value);
   void (__cdecl *PutString) (struct DvsPersist* self, const char* name, const char* value);
   void (__cdecl *PutBinary) (struct DvsPersist* self, const char* name, const void* value, int length);
   void (__cdecl *PutNull)   (struct DvsPersist* self, const char* name);

   int (__cdecl *GetInt)        (struct DvsPersist* self, const char* name, int default_value);
   int (__cdecl *GetDataLength) (struct DvsPersist* self, const char* name);
   int (__cdecl *GetString)     (struct DvsPersist* self, const char* name, char* buffer);
   int (__cdecl *GetBinary)     (struct DvsPersist* self, const char* name, void* buffer);

   struct DvsPersist * (__cdecl *OpenSubfolder) (struct DvsPersist* self, const char* name);

   void (__cdecl *Delete) (struct DvsPersist* self);
};


// Export from plugin DLL
/* struct DvpBaseFunctions* __cdecl DvdsynthBasePluginEntry(DvsBaseFunctions*); */


#endif