/* This header file is in the public domain. */


#ifndef __DVDSYNTH_SCSI_H
#define __DVDSYNTH_SCSI_H


typedef struct {   // 18 bytes, important fields marked with ***
   unsigned char errorcode;
   unsigned char segment_number;
   unsigned char sense_key;     // ***
   unsigned char information[4];
   unsigned char additional_length;   // 0x0A
   unsigned char command_specific[4];
   unsigned char asc;           // ***
   unsigned char ascq;          // ***
   unsigned char field_replaceable_unit_code;
   unsigned char sense_key_specific[3];
} SenseData;

#define SCSIOP_TEST_UNIT_READY     0x00
#define SCSIOP_REZERO_UNIT         0x01
#define SCSIOP_REWIND              0x01
#define SCSIOP_REQUEST_BLOCK_ADDR  0x02
#define SCSIOP_REQUEST_SENSE       0x03
#define SCSIOP_FORMAT_UNIT         0x04
#define SCSIOP_READ_BLOCK_LIMITS   0x05
#define SCSIOP_REASSIGN_BLOCKS     0x07
#define SCSIOP_INIT_ELEMENT_STATUS 0x07
#define SCSIOP_READ6               0x08
#define SCSIOP_RECEIVE             0x08
#define SCSIOP_WRITE6              0x0A
#define SCSIOP_PRINT               0x0A
#define SCSIOP_SEND                0x0A
#define SCSIOP_SEEK6               0x0B
#define SCSIOP_TRACK_SELECT        0x0B
#define SCSIOP_SLEW_PRINT          0x0B
#define SCSIOP_SEEK_BLOCK          0x0C
#define SCSIOP_PARTITION           0x0D
#define SCSIOP_READ_REVERSE        0x0F
#define SCSIOP_WRITE_FILEMARKS     0x10
#define SCSIOP_FLUSH_BUFFER        0x10
#define SCSIOP_SPACE               0x11
#define SCSIOP_INQUIRY             0x12
#define SCSIOP_VERIFY6             0x13
#define SCSIOP_RECOVER_BUF_DATA    0x14
#define SCSIOP_MODE_SELECT         0x15
#define SCSIOP_RESERVE_UNIT        0x16
#define SCSIOP_RELEASE_UNIT        0x17
#define SCSIOP_COPY                0x18
#define SCSIOP_ERASE               0x19
#define SCSIOP_MODE_SENSE6         0x1A
#define SCSIOP_START_STOP_UNIT     0x1B
#define SCSIOP_STOP_PRINT          0x1B
#define SCSIOP_LOAD_UNLOAD         0x1B
#define SCSIOP_RECEIVE_DIAGNOSTIC  0x1C
#define SCSIOP_SEND_DIAGNOSTIC     0x1D
#define SCSIOP_MEDIUM_REMOVAL      0x1E
#define SCSIOP_READ_FORMATTED_CAPACITY 0x23
#define SCSIOP_READ_CAPACITY       0x25
#define SCSIOP_READ                0x28
#define SCSIOP_WRITE               0x2A
#define SCSIOP_SEEK                0x2B
#define SCSIOP_LOCATE              0x2B
#define SCSIOP_POSITION_TO_ELEMENT 0x2B
#define SCSIOP_WRITE_VERIFY        0x2E
#define SCSIOP_VERIFY              0x2F
#define SCSIOP_SEARCH_DATA_HIGH    0x30
#define SCSIOP_SEARCH_DATA_EQUAL   0x31
#define SCSIOP_SEARCH_DATA_LOW     0x32
#define SCSIOP_SET_LIMITS          0x33
#define SCSIOP_READ_POSITION       0x34
#define SCSIOP_SYNCHRONIZE_CACHE   0x35
#define SCSIOP_COMPARE             0x39
#define SCSIOP_COPY_COMPARE        0x3A
#define SCSIOP_WRITE_DATA_BUFF     0x3B
#define SCSIOP_READ_DATA_BUFF      0x3C
#define SCSIOP_CHANGE_DEFINITION   0x40
#define SCSIOP_READ_SUBCHANNEL    0x42
#define SCSIOP_READ_TOC            0x43
#define SCSIOP_READ_HEADER         0x44
#define SCSIOP_PLAY_AUDIO          0x45
#define SCSIOP_PLAY_AUDIO_MSF      0x47
#define SCSIOP_PLAY_TRACK_INDEX    0x48
#define SCSIOP_PLAY_TRACK_RELATIVE 0x49
#define SCSIOP_PAUSE_RESUME        0x4B
#define SCSIOP_LOG_SELECT          0x4C
#define SCSIOP_LOG_SENSE           0x4D
#define SCSIOP_STOP_PLAY_SCAN      0x4E
#define SCSIOP_READ_DISK_INFORMATION 0x51
#define SCSIOP_READ_TRACK_INFORMATION 0x52
#define SCSIOP_MODE_SELECT10       0x55
#define SCSIOP_MODE_SENSE10        0x5A
#define SCSIOP_REPORT_LUNS         0xA0
#define SCSIOP_SEND_KEY            0xA3
#define SCSIOP_REPORT_KEY          0xA4
#define SCSIOP_MOVE_MEDIUM         0xA5
#define SCSIOP_LOAD_UNLOAD_SLOT    0xA6
#define SCSIOP_EXCHANGE_MEDIUM     0xA6
#define SCSIOP_SET_READ_AHEAD      0xA7
#define SCSIOP_READ12              0xA8
#define SCSIOP_READ_DVD_STRUCTURE  0xAD
#define SCSIOP_REQUEST_VOL_ELEMENT 0xB5
#define SCSIOP_SEND_VOLUME_TAG     0xB6
#define SCSIOP_READ_ELEMENT_STATUS 0xB8
#define SCSIOP_READ_CD_MSF         0xB9
#define SCSIOP_SCAN_CD             0xBA
#define SCSIOP_SET_CD_SPEED        0xBB
#define SCSIOP_PLAY_CD             0xBC
#define SCSIOP_MECHANISM_STATUS    0xBD
#define SCSIOP_READ_CD             0xBE
#define SCSIOP_INIT_ELEMENT_RANGE  0xE7

#define SRB_STATUS_PENDING                  0x00
#define SRB_STATUS_SUCCESS                  0x01
#define SRB_STATUS_ABORTED                  0x02
#define SRB_STATUS_ABORT_FAILED             0x03
#define SRB_STATUS_ERROR                    0x04
#define SRB_STATUS_BUSY                     0x05
#define SRB_STATUS_INVALID_REQUEST          0x06
#define SRB_STATUS_INVALID_PATH_ID          0x07
#define SRB_STATUS_NO_DEVICE                0x08
#define SRB_STATUS_TIMEOUT                  0x09
#define SRB_STATUS_SELECTION_TIMEOUT        0x0A
#define SRB_STATUS_COMMAND_TIMEOUT          0x0B
#define SRB_STATUS_MESSAGE_REJECTED         0x0D
#define SRB_STATUS_BUS_RESET                0x0E
#define SRB_STATUS_PARITY_ERROR             0x0F
#define SRB_STATUS_REQUEST_SENSE_FAILED     0x10
#define SRB_STATUS_NO_HBA                   0x11
#define SRB_STATUS_DATA_OVERRUN             0x12
#define SRB_STATUS_UNEXPECTED_BUS_FREE      0x13
#define SRB_STATUS_PHASE_SEQUENCE_FAILURE   0x14
#define SRB_STATUS_BAD_SRB_BLOCK_LENGTH     0x15
#define SRB_STATUS_REQUEST_FLUSHED          0x16
#define SRB_STATUS_INVALID_LUN              0x20
#define SRB_STATUS_INVALID_TARGET_ID        0x21
#define SRB_STATUS_BAD_FUNCTION             0x22
#define SRB_STATUS_ERROR_RECOVERY           0x23
#define SRB_STATUS_NOT_POWERED              0x24

#define SRB_STATUS_AUTOSENSE_VALID          0x80

#define SCSISTAT_GOOD                  0x00
#define SCSISTAT_CHECK_CONDITION       0x02
#define SCSISTAT_CONDITION_MET         0x04
#define SCSISTAT_BUSY                  0x08
#define SCSISTAT_INTERMEDIATE          0x10
#define SCSISTAT_INTERMEDIATE_COND_MET 0x14
#define SCSISTAT_RESERVATION_CONFLICT  0x18
#define SCSISTAT_COMMAND_TERMINATED    0x22
#define SCSISTAT_QUEUE_FULL            0x28

#define SCSI_SENSE_NO_SENSE         0x00
#define SCSI_SENSE_RECOVERED_ERROR  0x01
#define SCSI_SENSE_NOT_READY        0x02
#define SCSI_SENSE_MEDIUM_ERROR     0x03
#define SCSI_SENSE_HARDWARE_ERROR   0x04
#define SCSI_SENSE_ILLEGAL_REQUEST  0x05
#define SCSI_SENSE_UNIT_ATTENTION   0x06
#define SCSI_SENSE_DATA_PROTECT     0x07
#define SCSI_SENSE_BLANK_CHECK      0x08
#define SCSI_SENSE_UNIQUE           0x09
#define SCSI_SENSE_COPY_ABORTED     0x0A
#define SCSI_SENSE_ABORTED_COMMAND  0x0B
#define SCSI_SENSE_EQUAL            0x0C
#define SCSI_SENSE_VOL_OVERFLOW     0x0D
#define SCSI_SENSE_MISCOMPARE       0x0E
#define SCSI_SENSE_RESERVED         0x0F


typedef unsigned int scsi_result_t;

#define MAKE_SCSIRESULT(srb_stat,targ_stat,sense_key,asc,ascq) \
   (((scsi_result_t)((srb_stat) & 0x3F) << 25) | ((scsi_result_t)((targ_stat) & 0x3E) << 19) | ((scsi_result_t)((sense_key) & 0x0F) << 16) | ((scsi_result_t)((asc) & 0xFF) << 8) | (scsi_result_t)((ascq) & 0xFF))

#define SCSIRESULT_SRBSTAT(s) (((scsi_result_t)(s) >> 25) & 0x3F)
#define SCSIRESULT_TARGSTAT(s) (((scsi_result_t)(s) >> 19) & 0x3E)
#define SCSIRESULT_SENSE(s) ((scsi_result_t)(s) & 0xFFFFF)
#define SCSIRESULT_SENSEKEY(s) (((scsi_result_t)(s) >> 16) & 0x0F)
#define SCSIRESULT_ASC(s) (((scsi_result_t)(s) >> 8) & 0xFF)
#define SCSIRESULT_ASCQ(s) ((scsi_result_t)(s) & 0xFF)

#define MAKE_SCSIRESULT_ERROR(sense) ((SRB_STATUS_ERROR << 25) | (SCSISTAT_CHECK_CONDITION << 19) | (sense & 0xFFFFF))

#define SCSIRESULT_SUCCESS         MAKE_SCSIRESULT(SRB_STATUS_SUCCESS,SCSISTAT_GOOD,0,0,0)
#define SCSIRESULT_INVALID_CDB     MAKE_SCSIRESULT_ERROR(0x52400)
#define SCSIRESULT_ILLEGAL_COMMAND MAKE_SCSIRESULT_ERROR(0x52000)

#define SCSIRESULT_IS_SUCCESS(s) (((s) & 0xFFF00000) == SCSIRESULT_SUCCESS)


#endif
