/* This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
** 02111-1307, USA.
*/

#ifndef __KEYUTILS_INCLUDED__
#define __KEYUTILS_INCLUDED__

static u_int8_t SUCCESS = 0;
static u_int8_t ERR_USAGE = 1;
static u_int8_t ERR_FILEOPEN = 2;
static u_int8_t ERR_FILECREATE = 3;
static u_int8_t ERR_NOAACTRACK = 4;
static u_int8_t ERR_REMUX = 5;
static u_int8_t ERR_METADATA = 6;
static u_int8_t ERR_NOKEY = 7;

static const char *ERROR_MESSAGES[8] =
{
    /*SUCCESS*/        "Success.",
    /*ERR_USAGE*/      "USAGE: %s [-at] <infile> <outfile>\n\
 \t-a  don't copy artwork\n\
 \t-t  don't copy tags\n",
    /*ERR_FILEOPEN*/   "Couldn't open file: %s",
    /*ERR_FILECREATE*/ "Couldn't create file: %s",
    /*ERR_NOAACTRACK*/ "Couldn't find AAC track in input file.",
    /*ERR_REMUX*/      "Couldn't decode input file.",
    /*ERR_METADATA*/   "Couldn't set meta data on output file.",
    /*ERR_NOKEY*/      "Couldn't find iTunes key or an iPod."
};

/* EOF */
#endif /* __KEYUTILS_INCLUDED__ */
