/* $Id: keyutils.c,v 1.1 2004/04/02 23:35:38 play_fair Exp $
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111,
** USA.
*/

#include <stdlib.h>
#include <dirent.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef HAVE_LIMITS_H
#   include <limits.h>
#endif
#ifdef HAVE_GETPWUID
#    include <pwd.h>
#endif
#ifdef HAVE_STRING_H
#    include <string.h>
#endif
#ifdef HAVE_SYS_TYPES_H
#   include <sys/types.h>
#endif

#include "keyutils.h"

#ifdef _WIN32
#   define DRMS_DIRNAME "drms"
#else
#   define DRMS_DIRNAME ".drms"
#endif

#define IPOD_ENV "IPOD"
#define IPOD_CONTROL_DIRNAME "iPod_Control"

bool set_keyenv( void )
{
    char key_path[PATH_MAX], mnt_path[PATH_MAX],
        ipod_path[PATH_MAX], ipc_path[PATH_MAX];
    DIR *keydir, *ipoddir, *mntdir;
    struct dirent *dp, *dp2;

    snprintf( key_path, PATH_MAX - 1, "%s/" DRMS_DIRNAME, get_homedir() );
    keydir = opendir(key_path);

    if (NULL == keydir)
    {
        /* No key dir found.  Make sure that either (a) we are on
         * Windows or (b) an iPod is connected and can be found.
         */
#ifdef _WIN32
        return TRUE;
#else
        /* We'll first check for /Volumes, then /mnt.  If neither are
         * found, give up.
         */
        strcpy(mnt_path, "/Volumes");
        mntdir = opendir(mnt_path);
        if (NULL == mntdir)
        {
            strcpy(mnt_path, "/mnt");
            mntdir = opendir(mnt_path);
            if (NULL == mntdir)
            {
                return FALSE;
            }
        }

        while ((dp = readdir(mntdir)) != NULL)
        {
            snprintf(ipod_path, PATH_MAX - 1, "%s/%s", mnt_path, dp->d_name);
            if (dp->d_name[0] != '.')
            {
                ipoddir = opendir(ipod_path);
                if (NULL != ipoddir)
                {
                    while ((dp2 = readdir(ipoddir)) != NULL)
                    {
                        if (!strcmp(dp2->d_name, IPOD_CONTROL_DIRNAME))
                        {
                            setenv(IPOD_ENV, ipod_path, 0);
                            return TRUE;
                        }
                    }
                }
            }
        }
 #endif
    }
    else
    {
        return TRUE;
    }
}

char* get_homedir( void )
{
    char *p_tmp, *p_homedir = NULL;

#if defined(HAVE_GETPWUID)
    struct passwd *p_pw = NULL;
#endif

#if defined(_WIN32) || defined(UNDER_CE)
    typedef HRESULT (WINAPI *SHGETFOLDERPATH)( HWND, int, HANDLE, DWORD,
                                               LPSTR );
#   define CSIDL_FLAG_CREATE 0x8000
#   define CSIDL_APPDATA 0x1A
#   define SHGFP_TYPE_CURRENT 0

    HINSTANCE shfolder_dll;
    SHGETFOLDERPATH SHGetFolderPath ;
    /* load the shfolder dll to retrieve SHGetFolderPath */
    if( ( shfolder_dll = LoadLibrary( _T("SHFolder.dll") ) ) != NULL )
    {
        SHGetFolderPath = (void *)GetProcAddress( shfolder_dll,
                                                  _T("SHGetFolderPathA") );
        if ( SHGetFolderPath != NULL )
        {
            p_homedir = (char *)malloc( MAX_PATH );
            if( !p_homedir )
            {
                return NULL;
            }

            /* get the "Application Data" folder for the current user */
            if( S_OK == SHGetFolderPath( NULL,
                                         CSIDL_APPDATA | CSIDL_FLAG_CREATE,
                                         NULL, SHGFP_TYPE_CURRENT,
                                         p_homedir ) )
            {
                FreeLibrary( shfolder_dll );
                return p_homedir;
            }
            free( p_homedir );
        }
        FreeLibrary( shfolder_dll );
    }
#endif

#if defined(HAVE_GETPWUID)
    if( ( p_pw = getpwuid( getuid() ) ) == NULL )
#endif
    {
        if( ( p_tmp = getenv( "HOME" ) ) == NULL )
        {
            if( ( p_tmp = getenv( "TMP" ) ) == NULL )
            {
                p_tmp = "/tmp";
            }
        }

        p_homedir = strdup( p_tmp );
    }
#if defined(HAVE_GETPWUID)
    else
    {
        p_homedir = strdup( p_pw->pw_dir );
    }
#endif

    return p_homedir;
}

/* EOF */
